/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.util.Tuple;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpBoundsProcessor
extends Processor {
    private static final Logger log = LoggerFactory.getLogger(DumpBoundsProcessor.class);

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        ArrayList<OpHolder> holders = Lists.newArrayListWithCapacity(ops.size());
        for (Operation op : ops) {
            holders.add(new OpHolder(op));
        }
        Collections.sort(holders);
        try {
            Path outF = Files.createTempFile("mokos-bounds-dump-", ".txt", new FileAttribute[0]);
            Pattern p = Pattern.compile("@[0-9a-f]+");
            try (BufferedWriter w = Files.newBufferedWriter(outF, StandardCharsets.UTF_8, new OpenOption[0]);
                 PrintWriter out = new PrintWriter(w);){
                for (OpHolder holder : holders) {
                    out.println(holder.key);
                    String bounds = p.matcher(holder.op.getBounds().toString()).replaceAll("");
                    ArrayList<String> boundLines = Lists.newArrayList(Splitter.on('\n').split(bounds));
                    Collections.sort(boundLines);
                    out.println(Joiner.on('\n').join(boundLines));
                }
            }
            log.info("Wrote bounds information to {}", (Object)outF);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.getScheduler().stopPlanning();
        return Tuple.create(this.getDefaultSuccessor(), Collections.emptySet());
    }

    private static class OpHolder
    implements Comparable<OpHolder> {
        final Operation op;
        final String key;

        OpHolder(Operation op) {
            this.op = op;
            this.key = this.createKey(op);
        }

        private String createKey(Operation op) {
            GeneralizedOrderRequest gor = (GeneralizedOrderRequest)op.getGar().getParent();
            Action a = op.getAction();
            return "GOR: " + gor.getId() + " GAR: " + a.getName() + " LA: " + a.getLocalAltName();
        }

        @Override
        public int compareTo(@Nonnull OpHolder o) {
            return this.key.compareTo(o.key);
        }
    }
}

